//=============================================================================
// NUUN_ItemBook_KuroCustom.js
// ----------------------------------------------------------------------------
// (C)2023 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/03/06 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc アイテム図鑑新規取得情報格納
 * @target MZ
 * @author くろあめ
 *
 * @param NewGetSwitch
 * @text アイテム図鑑新規フラグ格納スイッチ
 * @desc このスイッチがONのとき、文章を一括表示します。デフォルトは5です。
 * @type switch
 * @default 0
 *
 * @help
 * NUUNさんのアイテム図鑑プラグインで、アイテムを登録する際に
 * 指定したスイッチに、そのアイテムが初めて入手した物かどうかの判定を格納します
 * 初入手の場合、指定したスイッチはONになり、取得済みの場合はOFFになります。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

    const _Game_Party_gainItem = Game_Party.prototype.gainItem;
    Game_Party.prototype.gainItem = function(item, amount, includeEquip) {
      if(amount > 0 && !$gameSystem.isInItemBook(item)){
          $gameSwitches.setValue(param.NewGetSwitch,true);
      }
      else{
          $gameSwitches.setValue(param.NewGetSwitch,false);
      }
      
      _Game_Party_gainItem.call(this, item, amount, includeEquip);
    };
    
})();